function mkElem(tag, attrs, child) {
    var elem = $("<" + tag + " />").attr(attrs),
        childArray = $.makeArray(child);
    return $.each(childArray, (function (i, c) {
        elem.append(c)
    })), elem
}

function mkElemClass(tag, classes, child) {
    return mkElem(tag, {
        class: classes
    }, child)
}

function mkModal(id, extraClasses, title, body, footer, canClose, closeHndlr) {
    return mkElem("div", {
        id: id,
        class: "modal hide " + extraClasses
    }, [mkElemClass("div", "modal-header", [canClose ? mkElem("button", {
        type: "button",
        class: "msgBtn close",
        "data-dismiss": "modal"
    }, "&#215;").click(closeHndlr) : null, mkElem("h3", {}, title)]), mkElemClass("div", "modal-body", mkElem("p", {}, body)), mkElemClass("div", "modal-footer", footer)])
}
var standardModalOptions = {
    backdrop: "static",
    keyboard: !1
};

function mkModalElem(id, extraClasses, title, body, footer, options, canClose, closeHndlr) {
    var elem = mkElem("div", {
        id: id,
        class: "modal hide " + extraClasses
    }, [mkElemClass("div", "modal-header", [canClose ? mkElem("button", {
        type: "button",
        class: "msgBtn close",
        "data-dismiss": "modal"
    }, "&#215;").click(closeHndlr) : null, mkElem("h3", {}, title)]), mkElemClass("div", "modal-body", mkElem("p", {}, body)), mkElemClass("div", "modal-footer", footer)]);
    return $(elem).modal(options), elem
}

function curry(f) {
    var args = $.makeArray(arguments).slice(1);
    return args.length,
        function () {
            if (f) return f.apply(this, args.concat($.makeArray(arguments)))
        }
}

function showMessageModal(title, body, onClose) {
    mkModalElem("msgModal", "", title, body, mkElem("button", {
        id: "MSG_BT",
        type: "button",
        class: "msgBtn",
        "data-dismiss": "modal"
    }, okLang).click(onClose), standardModalOptions, !0, onClose), document.getElementById("MSG_BT").blur(), document.getElementById("MSG_BT").focus()
}

function showOverlaidMessageModal(title, body, onClose) {
    showMessageModal(title, body, (function () {
        onClose && onClose()
    }))
}

function showConfirmationModal(title, body, yesHndlr, noHndlr, isDangerous) {
    var yesClass, modalElem;
    modalElem = mkModal("confirmModal", "", title, body, [mkElem("button", {
        type: "button",
        class: "Btn_style",
        "data-dismiss": "modal"
    }, yesLang).click(yesHndlr), mkSpace(), mkSpace(), mkSpace(), mkSpace(), mkElem("button", {
        type: "button",
        class: "Btn_style",
        "data-dismiss": "modal"
    }, noLang).click(noHndlr)], !0, noHndlr), $(modalElem).modal(standardModalOptions)
}

function blockUIforPage(info) {
    $.blockUI({
        css: {
            border: "none",
            padding: "15px",
            backgroundColor: "#000",
            "-webkit-border-radius": "10px",
            "-moz-border-radius": "10px",
            opacity: .6,
            color: "#ffffff"
        },
        message: "<h3>" + info + "</h3>"
    })
}

var uitimeout = -1,
    uiinfo = "",
    prvinfo;

function unblockUIforPage() {
    $.unblockUI(), uitimeout = -1, prvinfo = "", "" != uiinfo && showMessageModal("訊息", uiinfo)
}

function SetunblockUIforPage(timeout, timeoutinfo) {
    -1 != uitimeout && clearTimeout(uitimeout), uiinfo = timeoutinfo, uitimeout = setTimeout("unblockUIforPage()", timeout)
}

function resetAction(timeout, info, timeoutinfo) {
    prvinfo != info && "" != info && (prvinfo = info, blockUIforPage(info)), SetunblockUIforPage(timeout, timeoutinfo)
}